<div class="content-wrapper">

<script>
// Función global para exportar Excel - DEBE estar definida antes del botón
function exportarExcelDetalleConta() {
  console.log("exportarExcelDetalleConta llamada");
  
  if (typeof jQuery === 'undefined') {
    alert("Error: jQuery no está cargado");
    return;
  }
  
  if (typeof XLSX === 'undefined') {
    alert("Error: La librería XLSX no está cargada");
    return;
  }
  
  var tipoServiciosD = jQuery("#tipoServicio").val() || "";
  var estadoServiciosD = jQuery("#estadoServicio").val() || "";
  var zonaBloquesD = jQuery("#zonaDetallados").val() || "";

  console.log("Filtros:", tipoServiciosD, estadoServiciosD, zonaBloquesD);

  var datos = new FormData();
  datos.append("tipoServiciosD", tipoServiciosD);
  datos.append("estadosServiciosD", estadoServiciosD);
  datos.append("zonaBloquesD", zonaBloquesD);

  jQuery.ajax({
    url: "ajax/reportes.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(response) {
      console.log("Respuesta recibida:", response);
      
      if (!Array.isArray(response)) {
        console.error("Respuesta no es array:", response);
        alert("Error: Los datos recibidos no son válidos.");
        return;
      }
      if (response.length === 0) {
        alert("No hay datos para exportar.");
        return;
      }

      var wb = XLSX.utils.book_new();
      var ws_data = [ 
        ['#', 'BLOQUE', 'DIPLOMADO', 'ESTADO DEL PAGO', 'PARTICIPANTE', 'FOLIO', 'METODO DE PAGO', 'BANCO', 'REFERENCIA', 'COMPROMETIDO', 'COBRADO', 'NOTAS DEL COBRADOR', 'FECHA ACORDADA', 'FECHA DE PAGO', 'COBRADOR']
      ];

      // Función para obtener el estilo según el estado
      function getStyleForEstado(estado) {
        estado = (estado || '').toString().toUpperCase().trim();
        
        switch(estado) {
          case 'PAGADO':
            return {
              fill: { fgColor: { rgb: "C6EFCE" } }, // Verde claro
              font: { color: { rgb: "006100" }, bold: true } // Verde oscuro, negrita
            };
          case 'PENDIENTE':
            return {
              fill: { fgColor: { rgb: "FFEB9C" } }, // Amarillo claro
              font: { color: { rgb: "9C6500" }, bold: true } // Naranja oscuro, negrita
            };
          case 'ATRASADO':
            return {
              fill: { fgColor: { rgb: "FFC7CE" } }, // Rojo claro
              font: { color: { rgb: "9C0006" }, bold: true } // Rojo oscuro, negrita
            };
          case 'BAJA':
            return {
              fill: { fgColor: { rgb: "D9D9D9" } }, // Gris claro
              font: { color: { rgb: "000000" }, bold: true } // Negro, negrita
            };
          default:
            return {
              fill: { fgColor: { rgb: "FFFFFF" } }, // Blanco
              font: { color: { rgb: "000000" } } // Negro normal
            };
        }
      }

      response.forEach(function(val, index) {
        var row = [];
        var estado = val["ESTADO_DEL_PAGO"] || '';
        var estadoStyle = getStyleForEstado(estado);
        
        // Agregar cada celda con su valor
        row.push(index + 1);
        row.push(val["BLOQUE"] || '');
        row.push(val["DIPLOMADO"] || '');
        row.push({v: estado, s: estadoStyle}); // Celda de estado con estilo
        row.push(val["PARTICIPANTE"] || '');
        row.push(val["FOLIO"] || '');
        row.push(val["METODO_DE_PAGO"] || '');
        row.push(val["BANCO"] || '');
        row.push(val["REFERENCIA"] || '');
        row.push(val["COMPROMETIDO"] || '');
        row.push(val["COBRADO"] || '');
        row.push(val["NOTAS DEL COBRADOR"] || '');
        row.push(val["FECHA_ACORDADA"] || '');
        row.push(val["FECHA_DE_PAGO"] || '');
        row.push(val["COBRADOR"] || '');
        
        ws_data.push(row);
      });

      // Crear la hoja con soporte para estilos
      var ws = XLSX.utils.aoa_to_sheet(ws_data, {cellStyles: true});
      
      // Aplicar estilos también a toda la fila basado en el estado
      response.forEach(function(val, index) {
        var estado = (val["ESTADO_DEL_PAGO"] || '').toString().toUpperCase().trim();
        var estadoStyle = getStyleForEstado(estado);
        var rowNum = index + 2; // +2 porque la fila 1 es el encabezado
        
        // Aplicar estilo a la celda de estado (columna D)
        if (!ws['D' + rowNum]) ws['D' + rowNum] = {};
        if (!ws['D' + rowNum].s) ws['D' + rowNum].s = {};
        ws['D' + rowNum].s = estadoStyle;
      });
      
      XLSX.utils.book_append_sheet(wb, ws, "Reporte");
      XLSX.writeFile(wb, 'reporte_general_detallado.xlsx');
      console.log("Excel generado exitosamente");
    },
    error: function(xhr, status, error) {
      console.error("Error AJAX:", error);
      console.error("Status:", status);
      console.error("Response:", xhr.responseText);
      alert("Error al obtener los datos. Ver consola para más detalles.");
    }
  });
}
</script>

  <section class="content-header">

    <h1>

      Reporte detallado de cobros y por recuperar

    </h1>

    <ol class="breadcrumb">

      <li><a href="inicio"><i class="fa fa-dashboard"></i> Inicio</a></li>

      <li class="active">Reporte detallado de cobros y por recuperar</li>

    </ol>

  </section>

  <section class="content">

    <div class="box">

      <div class="box-header with-border">



        <div class="form-row">

                    <div class="form-group col-md-3">
                      <label for="fechaInicio">mes del reporte:</label>
                      <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                        <input type="month" class="form-control" id="tipoServicio" name="tipoServicio" required>
                      </div>
                    </div>

                    <div class="form-group col-md-3">
                      <label for="inputCity">ESTADO DEL PAGO:</label>
                      <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-flag-checkered"></i></span>
                        <select class="form-control" id="estadoServicio" name="estadoServicio" required>
                          <option value="">Seleccione</option>
                          <option value="PAGADO">PAGADO</option>
                          <option value="PENDIENTE">PENDIENTE</option>
                          <option value="ATRASADO">ATRASADO</option>
                          <option value="BAJA">BAJA</option>
                        </select>
                      </div>
                    </div>

                    <div class="form-group col-md-3">
                      <label for="inputCity">BLOQUE</label>
                      <div class="input-group">
                      <span class="input-group-addon"><i class="fa fa-flag-checkered"></i></span>
                      <?php
                        $zonas = ControladorDirecciones::ctrMostrarZona(); ?>
                      <select class="form-control" id="zonaDetallados" name="zonaDetallados" required>
                              <option value="">Seleccione</option>
                              <?php foreach($zonas as $fila){ ?>
                              <option value="<?= $fila['nombre_zona'] ?>"><?= $fila['nombre_zona'] ?></option>
                              <?php } ?>

                            </select>
                      </div>
                    </div>

                    <div class="form-group col-md-3">
                      <label for="inputCity"><i class="fa fa-file-pdf-o"></i> </label>
                      <div class="input-group">


                      
                      <button type="button" id="btnExportarExcelito" class="btn btn-success" onclick="exportarExcelDetalleConta(); return false;">
                            <i class="fas fa-file-excel"></i> Exportar a Excel
                      </button>

                      </div>
                    </div>

                  </div>





      </div>

      <div class="box-body">

       <table class="table table-bordered table-striped dt-responsive tablas serviConti">

        <thead>

         <tr>

           <th style="width:10px">#</th>
           <th style="width: 50px;">BLOQUE</th>
           <th>DIPLOMADO</th>
           <th>ESTADO DE PAGO</th>
           <th>PARTICIPANTE</th>
           <th>FOLIO</th>
           <th>METODO DE PAGO</th>
           <th>BANCO</th>
           <th>REFERENCIA</th>
           <th>COMPROMETIDO</th>
           <th>COBRADO</th>
           <th>NOTAS DEL COBRADOR</th>
           <th>FECHA ACORDADA</th>
           <th>FECHA DE PAGO</th>
           <th>COBRADOR</th>

         </tr>

        </thead>

        <tbody id="serviCont">

        <?php

        $item = null;
        $valor = null;

        $contratos = ControladorContratos::ctrDetalleCobRed($item, $valor);
        //Parse error: syntax error, unexpected end of file in C:\xampp\htdocs\SisRecoleccion\vistas\modulos\contratos.php on line 111

       foreach ($contratos as $key => $value){

          echo ' <tr>
                  <td>'.($key+1).'</td>
                  <td>'.$value["BLOQUE"].'</td>';
                echo '<td>'.$value["DIPLOMADO"].'</td>';

                echo '<td>'.$value["ESTADO_DEL_PAGO"].'</td>';
                echo '<td>'.$value["PARTICIPANTE"].'</td>';
                echo '<td>'.$value["FOLIO"]. '</td>';
                echo '<td>'.$value["METODO_DE_PAGO"]. '</td>';
                echo '<td>'.$value["BANCO"]. '</td>';
                echo '<td>'.$value["REFERENCIA"]. '</td>';
                $comprometido = isset($value["COMPROMETIDO"]) && $value["COMPROMETIDO"] !== '' ? floatval($value["COMPROMETIDO"]) : 0;
                $cobrado = isset($value["COBRADO"]) && $value["COBRADO"] !== '' ? floatval($value["COBRADO"]) : 0;
                echo '<td>$' . number_format($comprometido, 2, '.', ',') . '</td>';
                echo '<td>$' . number_format($cobrado, 2, '.', ',') . '</td>';
               echo '<td>'.$value["NOTAS DEL COBRADOR"].'</td>';
               echo '<td>'.$value["FECHA_ACORDADA"].'</td>';
               echo '<td>'.$value["FECHA_DE_PAGO"].'</td>';
               echo '<td>'.$value["COBRADOR"].'</td>';


                      echo '</div>

                    </td>



                </tr>';
        }


        ?>

        </tbody>

       </table>

      </div>

    </div>

  </section>

</div>



<div id="modalEditarContrato" class="modal fade" role="dialog">

<div class="modal-dialog modal-lg">
    <div class="modal-content">

      <form role="form" method="post">







        <!--=====================================
        PIE DEL MODAL
        ======================================-->

        <div class="modal-footer">

          <button type="button" class="btn btn-danger pull-right" data-dismiss="modal">Close</button>


        </div>

      </form>

      </div>

  </div>

</div>
